
/*******************************************************************************/
/*  
	This script produces Table B4 and B5
	Mongey, Pilossoph, and Weinberg: "Which Workers Bear the Burden of Social Distancing?"
	Journal of Economic Inequality 2021	
    --
	Alexander Weinberg
	February 16, 2021
*/
/*******************************************************************************/

//________________________________________________________________
// Load covid module of CPS
use "../Data/CPS/cps_covid", clear

// __________________________________________________
// LWFH* Share teleworking Table
preserve
	collapse (mean) covidtelew [pw=compwt], by(month low_wfh_binary)
	list
	export delimited "../Tables/tableB4_LWFH.csv", replace
restore

// __________________________________________________
// HPP* Share teleworking Table
preserve
	collapse (mean) covidtelew [pw=compwt], by(month high_pp_binary)
	list
	export delimited "../Tables/tableB4_HPP.csv", replace
restore

// __________________________________________________
// Share teleworking Table -- All occupations
preserve
	collapse (mean) covidtelew [pw=compwt], by(month)
	list
	export delimited "../Tables/tableB4_all.csv", replace
restore


//__________________________________________________
// Regressions
estimates clear 
eststo: reg covidtelew low_wfh_binary [pw=compwt]	
eststo: reg covidtelew high_pp_binary [pw=compwt]	
eststo: reg covidtelew low_wfh_binary high_pp_binary [pw=compwt]	
eststo: reg covidtelew low_wfh_binary high_pp_binary i.month [pw=compwt]
eststo: reg covidtelew low_wfh_binary high_pp_binary i.critical i.month [pw=compwt]

esttab * using "../Tables/tableB5.tex", booktabs star r2 se replace type ///
	title("Share teleworking due to Covid-19 Pandemic") ///
	nomtitles addnotes("Regressions are conditional on employment. We use the SOC-based measure of essential workers.") ///
	label drop(0.critical)

// end
